/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import tictim.paraglider.contents.Contents;

public class CosmeticRecipe
implements ICraftingRecipe {
    private final ResourceLocation id;
    private final String group;
    private final Ingredient input;
    private final Ingredient reagent;
    private final Item recipeOut;

    public CosmeticRecipe(ResourceLocation id, String group, Ingredient input, Ingredient reagent, Item recipeOut) {
        this.id = id;
        this.group = group;
        this.input = input;
        this.reagent = reagent;
        this.recipeOut = recipeOut;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        boolean paragliderSeen = false;
        boolean reagentSeen = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.reagent.test(stack)) {
                if (reagentSeen) {
                    return false;
                }
                reagentSeen = true;
                continue;
            }
            if (this.input.test(stack) && stack.func_77973_b() != this.recipeOut) {
                if (paragliderSeen) {
                    return false;
                }
                paragliderSeen = true;
                continue;
            }
            return false;
        }
        return paragliderSeen && reagentSeen;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        ItemStack paraglider = new ItemStack((IItemProvider)this.recipeOut);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || this.reagent.test(stack) || !this.input.test(stack)) continue;
            if (stack.func_77942_o()) {
                paraglider.func_77982_d(stack.func_77978_p());
            }
            return paraglider;
        }
        return paraglider;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public ItemStack func_77571_b() {
        return new ItemStack((IItemProvider)this.recipeOut);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (this.reagent.test(item)) {
                ItemStack copy = item.func_77946_l();
                copy.func_190920_e(1);
                list.set(i, (Object)copy);
                continue;
            }
            if (!item.hasContainerItem()) continue;
            list.set(i, (Object)item.getContainerItem());
        }
        return list;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList list = NonNullList.func_191196_a();
        list.add((Object)Ingredient.func_193369_a((ItemStack[])((ItemStack[])Arrays.stream(this.input.func_193365_a()).filter(it -> it.func_77973_b() != this.recipeOut).toArray(ItemStack[]::new))));
        list.add((Object)this.reagent);
        return list;
    }

    public String func_193358_e() {
        return this.group;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Contents.COSMETIC_RECIPE.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<CosmeticRecipe> {
        public CosmeticRecipe read(ResourceLocation recipeId, JsonObject json) {
            String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ResourceLocation itemName = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"result"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemName);
            if (item == null || !Objects.equals(item.getRegistryName(), itemName)) {
                throw new JsonSyntaxException("Unknown item '" + group + "'");
            }
            Ingredient input = Ingredient.func_199802_a((JsonElement)json.get("input"));
            Ingredient reagent = Ingredient.func_199802_a((JsonElement)json.get("reagent"));
            return new CosmeticRecipe(recipeId, group, input, reagent, item);
        }

        @Nullable
        public CosmeticRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            String group = buffer.func_150789_c(Short.MAX_VALUE);
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            Ingredient reagent = Ingredient.func_199566_b((PacketBuffer)buffer);
            Item out = Item.func_150899_d((int)buffer.func_150792_a());
            return new CosmeticRecipe(recipeId, group, input, reagent, out);
        }

        public void write(PacketBuffer buffer, CosmeticRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            recipe.input.func_199564_a(buffer);
            recipe.reagent.func_199564_a(buffer);
            buffer.func_150787_b(Item.func_150891_b((Item)recipe.recipeOut));
        }
    }
}

